<?php

namespace App\Exceptions;

use Illuminate\Foundation\Exceptions\Handler as ExceptionHandler;
use Throwable;

class Handler extends ExceptionHandler
{
    
    public function render($request, Throwable $exception)
{
    // إذا كان الخطأ هو مصادقة غير صحيحة (مثلاً Token مفقود أو غير صالح)
    if ($exception instanceof AuthenticationException) {
        return response()->json([
            'error' => 'Unauthorized',
            'message' => 'The user is not authorized to access this resource.',
        ], 401);  // استجابة 401 Unauthorized
    }

    // إذا كان الخطأ يتعلق بمطابقة الـ CSRF Token
    if ($exception instanceof TokenMismatchException) {
        return response()->json([
            'error' => 'CSRF Token Mismatch',
            'message' => 'The CSRF token is missing or invalid.',
        ], 419);  // استجابة 419 Token Mismatch
    }

    // إذا كان الخطأ متعلقا بعدم وجود مورد معين (مثلاً صورة غير موجودة)
    if ($exception instanceof ModelNotFoundException) {
        return response()->json([
            'error' => 'Resource Not Found',
            'message' => 'The requested resource was not found.',
        ], 404);  // استجابة 404 Resource Not Found
    }

    // في حال كانت الأخطاء الأخرى، يمكنك إرسال استجابة عامة
    return parent::render($request, $exception);
}

    
    /**
     * A list of exception types with their corresponding custom log levels.
     *
     * @var array<class-string<\Throwable>, \Psr\Log\LogLevel::*>
     */
    protected $levels = [
        //
    ];

    /**
     * A list of the exception types that are not reported.
     *
     * @var array<int, class-string<\Throwable>>
     */
    protected $dontReport = [
        //
    ];

    /**
     * A list of the inputs that are never flashed to the session on validation exceptions.
     *
     * @var array<int, string>
     */
    protected $dontFlash = [
        'current_password',
        'password',
        'password_confirmation',
    ];

    /**
     * Register the exception handling callbacks for the application.
     */
    public function register(): void
    {
        $this->reportable(function (Throwable $e) {
            //
        });
    }
}
