<?php

// app/Http/Controllers/ComplaintController.php

namespace App\Http\Controllers;

use App\Models\Complaint;
use Illuminate\Http\Request;

class ComplaintController extends Controller
{
    // عرض جميع الشكاوى
    public function index()
    {
        return Complaint::all();
    }

    // إنشاء شكوى جديدة
    public function store(Request $request)
    {
        $request->validate([
            'phone' => 'required|string|max:20',
            'message' => 'required|string',
            'status' => 'required|string',
        ]);

        $complaint = Complaint::create($request->all());
        return response()->json($complaint, 201);
    }

    // عرض شكوى معينة
    public function show($id)
    {
        return Complaint::findOrFail($id);
    }

    // تحديث شكوى معينة
    public function update(Request $request, $id)
    {
        $complaint = Complaint::findOrFail($id);
        $complaint->update($request->all());
        return response()->json($complaint, 200);
    }

    // حذف شكوى معينة
    public function destroy($id)
    {
        Complaint::findOrFail($id)->delete();
        return response()->json(null, 204);
    }
}
