<?php

namespace App\Http\Controllers;

use App\Models\Integration;
use Illuminate\Http\Request;

class IntegrationController extends Controller
{
    // عرض قائمة الإعدادات
    public function index()
    {
        $integrations = Integration::all();
        return view('integrations.index', compact('integrations'));
    }

    // عرض نموذج إضافة إعداد جديد
    public function create()
    {
        return view('integrations.create');
    }

    // تخزين إعداد جديد
    public function store(Request $request)
    {
        $validated = $request->validate([
            'service' => 'required|string',
            'key' => 'required|string',
            'additional_info' => 'nullable|string',
        ]);

        Integration::create($validated);

        return redirect()->route('integrations.index')->with('success', 'إعداد جديد تم إضافته بنجاح!');
    }

    // عرض نموذج تعديل إعداد
    public function edit($id)
    {
        $integration = Integration::findOrFail($id);
        return view('integrations.edit', compact('integration'));
    }

    // تحديث إعداد موجود
    public function update(Request $request, $id)
    {
        $validated = $request->validate([
            'service' => 'required|string',
            'key' => 'required|string',
            'additional_info' => 'nullable|string',
        ]);

        $integration = Integration::findOrFail($id);
        $integration->update($validated);

        return redirect()->route('integrations.index')->with('success', 'تم تحديث الإعداد بنجاح!');
    }

    // حذف إعداد
    public function destroy($id)
    {
        $integration = Integration::findOrFail($id);
        $integration->delete();

        return redirect()->route('integrations.index')->with('success', 'تم حذف الإعداد بنجاح!');
    }
}
