<?php

// app/Http/Controllers/ProjectRequestController.php

namespace App\Http\Controllers;

use App\Models\ProjectRequest;
use Illuminate\Http\Request;

class ProjectRequestController extends Controller
{
    // عرض جميع طلبات المشاريع
    public function index()
    {
        return ProjectRequest::all();
    }

    // إنشاء طلب مشروع جديد
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'phone' => 'required|string|max:20',
            'city' => 'required|string|max:100',
            'project' => 'required|string|max:255',
            'amount' => 'required|numeric',
            'startDate' => 'required|date',
            'endDate' => 'required|date',
        ]);

        $projectRequest = ProjectRequest::create($request->all());
        return response()->json($projectRequest, 201);
    }

    // عرض طلب مشروع معين
    public function show($id)
    {
        return ProjectRequest::findOrFail($id);
    }

    // تحديث طلب مشروع معين
    public function update(Request $request, $id)
    {
        $projectRequest = ProjectRequest::findOrFail($id);
        $projectRequest->update($request->all());
        return response()->json($projectRequest, 200);
    }

    // حذف طلب مشروع معين
    public function destroy($id)
    {
        ProjectRequest::findOrFail($id)->delete();
        return response()->json(null, 204);
    }
}
