<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\Http;
use App\Models\RecurringDonation;
use Illuminate\Http\Request;
use Carbon\Carbon;
use Illuminate\Support\Facades\Log;


class RecurringDonationController extends Controller
{
    public function createToken(Request $request)
{
    // التحقق من صحة البيانات
    $request->validate([
        'name' => 'required|string',
        'number' => 'required|string',
        'month' => 'required|string',
        'year' => 'required|string',
        'cvc' => 'required|string',
        'callback_url' => 'required|url',
    ]);

    // إعداد بيانات التوكن
    $data = [
        "name" => $request->name,
        "number" => $request->number,
        "month" => $request->month,
        "year" => $request->year,
        "cvc" => $request->cvc,
        "callback_url" => $request->callback_url,
        "publishable_api_key" => "pk_live_LYfCFA3D24UULXqbSW3B7yUDDtbh6LYUVJ1VVGPp", // المفتاح الذي تم توفيره
    ];

    try {
        // إرسال الطلب إلى API موياسار
        $response = Http::withBasicAuth("pk_live_LYfCFA3D24UULXqbSW3B7yUDDtbh6LYUVJ1VVGPp", '') // المصادقة باستخدام المفتاح
            ->post('https://api.moyasar.com/v1/tokens', $data);

        if ($response->successful()) {
            // استخراج التوكن ورابط التحقق
            $responseData = $response->json();

            return response()->json([
                'message' => 'تم إنشاء التوكن بنجاح',
                'token' => $responseData['id'], // التوكن الذي تم إنشاؤه
                'verification_url' => $responseData['verification_url'], // رابط التحقق
            ]);
        } else {
            return response()->json([
                'error' => 'فشل في إنشاء التوكن',
                'message' => $response->json()['message'] ?? 'حدث خطأ غير معروف',
                'status' => $response->status(),
            ], 500);
        }
    } catch (\Exception $e) {
        return response()->json([
            'error' => 'حدث خطأ أثناء التواصل مع موياسار',
            'message' => $e->getMessage(),
        ], 500);
    }
}


public function processDonation(Request $request)
{
    // التحقق من صحة المدخلات
    $request->validate([
        'amount' => 'required|numeric',
        'currency' => 'required|string',
        'token' => 'required|string',
    ]);

    // تحضير البيانات
    $data = [
 "amount" => $request->amount * 100, // لتحويل الريال إلى هللة
            "currency" => $request->currency,
            "source" => [
                "type" => "token",
                "token" => $request->token,
                "3ds" => false,
        ],
    ];

    try {
        $response = Http::withBasicAuth("pk_live_LYfCFA3D24UULXqbSW3B7yUDDtbh6LYUVJ1VVGPp", '')
            ->post('https://api.moyasar.com/v1/payments', $data);

        Log::debug('API response:', $response->json());

        if ($response->successful()) {
            return response()->json([
                'message' => 'تم الدفع بنجاح',
                'payment_data' => $response->json(),
            ]);
        } else {
            // تسجيل المزيد من المعلومات حول الخطأ
            Log::error('Moyasar Error:', [
                'status' => $response->status(),
                'response' => $response->json(),
                'data_sent' => $data, // عرض البيانات المرسلة
            ]);

            // تقديم رسالة خطأ مفصلة
            return response()->json([
                'error' => 'فشل في إجراء الدفع',
                'message' => $response->json()['message'] ?? 'حدث خطأ غير معروف',
                'status' => $response->status(),
            ], $response->status());
        }
    } catch (\Exception $e) {
        Log::error('Exception:', [
            'message' => $e->getMessage(),
            'data_sent' => $data,
        ]);

        return response()->json([
            'error' => 'حدث خطأ أثناء التواصل مع موياسار',
            'message' => $e->getMessage(),
        ], 500);
    }
}




    public function registerRecurringDonation(Request $request)
    {
        // التحقق من البيانات الواردة
        $request->validate([
            'user_id' => 'required|integer',
            'amount' => 'required|numeric',
            'currency' => 'required|string',
            'token' => 'required|string',
            'frequency' => 'required|in:minutely,daily,weekly,monthly',
            'phone' => 'required|string', // إضافة التحقق من رقم الهاتف
        ]);

        // تحديد تاريخ التبرع القادم ككائن Carbon
        $nextDonationDate = Carbon::now();

        switch ($request->frequency) {
            case 'minutely':
                $nextDonationDate->addMinute();
                break;
            case 'daily':
                $nextDonationDate->addDay();
                break;
            case 'weekly':
                $nextDonationDate->addWeek();
                break;
            case 'monthly':
                $nextDonationDate->addMonth();
                break;
        }

        // حفظ بيانات التبرع الدوري
        $recurringDonation = RecurringDonation::create([
            'user_id' => $request->user_id,
            'amount' => $request->amount,
            'currency' => $request->currency,
            'token' => $request->token,
            'frequency' => $request->frequency,
            'next_donation_date' => $nextDonationDate,
            'last_donated_at' => Carbon::now(),
            'phone' => $request->phone, // حفظ رقم الهاتف
        ]);

        return response()->json(['message' => 'تم تسجيل التبرع الدوري بنجاح!', 'data' => $recurringDonation]);
    }
}
