<?php

namespace App\Http\Controllers;

use App\Models\Repair;
use Illuminate\Http\Request;

class RepairController extends Controller
{
    public function index()
    {
        $repairs = Repair::all();
        return response()->json($repairs);
    }

    public function store(Request $request)
    {
        $request->validate([
            'isRepair' => 'required|boolean',
            'repairTitle' => 'required|string|max:255',
        ]);

        $repair = Repair::create([
            'isRepair' => $request->isRepair,
            'repairTitle' => $request->repairTitle,
        ]);

        return response()->json($repair, 201);
    }

    public function show($id)
    {
        $repair = Repair::findOrFail($id);
        return response()->json($repair);
    }

    public function update(Request $request, $id)
    {
        $request->validate([
            'isRepair' => 'required|boolean',
            'repairTitle' => 'required|string|max:255',
        ]);

        $repair = Repair::findOrFail($id);
        $repair->update($request->all());

        return response()->json($repair);
    }

    public function destroy($id)
    {
        $repair = Repair::findOrFail($id);
        $repair->delete();

        return response()->json(null, 204);
    }
}
