<?php

namespace App\Http\Controllers;

use App\Models\RequestBalance;
use Illuminate\Support\Facades\Log;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;


class RequestBalanceController extends Controller
{
    // إنشاء طلب جديد
    public function store(Request $request)
    {
       $validated = $request->validate([
    'balance' => 'required|numeric',
    'amount' => 'required|numeric',
'transfer_image' => 'required|mimes:jpg,jpeg,png,pdf,gif,svg|max:10048',
    'site_url' => 'required|url',
    'status' => 'nullable|string',
    'api_key' => 'nullable|string',
]);


        $path = $request->file('transfer_image')->store('images', 'public');
        $validated['transfer_image'] = 'storage/' . $path;

        $balanceRequest = RequestBalance::create($validated);

        return response()->json([
            'message' => 'Balance request created successfully',
            'data' => $balanceRequest,
        ], 201);
    }

    // استعراض جميع الطلبات
public function index()
{
    $requests = RequestBalance::all()->map(function ($request) {
        if ($request->img) {
            $request->img = url('storage/' . $request->img);
        }
        return $request;
    });

    return response()->json($requests, 200);
}


    // استعراض طلب بناءً على ID
    public function show($id)
    {
        $balanceRequest = RequestBalance::findOrFail($id);
        return response()->json($balanceRequest, 200);
    }

    // تحديث طلب بناءً على ID
    public function update(Request $request, $id)
    {
        try {
          $validated = $request->validate([
    'balance' => 'numeric|nullable',
    'amount' => 'numeric|nullable',
'transfer_image' => 'required|mimes:jpg,jpeg,png,pdf,gif,svg|max:10048',
    'site_url' => 'url|nullable',
    'status' => 'string|nullable',
    'api_key' => 'string|nullable',
]);


            $balanceRequest = RequestBalance::findOrFail($id);

            if ($request->hasFile('transfer_image')) {
                $path = $request->file('transfer_image')->store('images', 'public');
                $validated['transfer_image'] = 'storage/' . $path;
            }

            $balanceRequest->update($validated);

            return response()->json([
                'message' => 'Balance request updated successfully',
                'data' => $balanceRequest,
            ], 200);
        } catch (\Exception $e) {
            Log::error('Error updating balance request: ' . $e->getMessage());

            return response()->json([
                'message' => 'Failed to update balance request',
                'error' => $e->getMessage(),
            ], 500);
        }
    }


    // حذف طلب بناءً على ID
    public function destroy($id)
    {
        $balanceRequest = RequestBalance::findOrFail($id);
        $balanceRequest->delete();

        return response()->json([
            'message' => 'Balance request deleted successfully',
        ], 200);
    }
}
