<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Stat;

class StatsController extends Controller
{
    // دالة لإرجاع بيانات الإحصائيات
    public function getStats()
    {
        $stat = Stat::first();

        if (!$stat) {
            return response()->json([
                'message' => 'لا توجد بيانات إحصائية متاحة.'
            ], 404);
        }

        return response()->json([
            'showStats' => $stat->show_stats,
            'statsHeading' => $stat->stats_heading,
            'description' => $stat->description,
        ]);
    }

    // دالة لإنشاء بيانات إحصائية جديدة
    public function createStats(Request $request)
    {
       $request->validate([
        'show_stats' => 'required|boolean',
        'stats_heading' => 'required|string|max:255',
        'description' => 'required|string|max:255',
    ]);

    // حذف جميع السجلات القديمة
    Stat::truncate();

    // إضافة السجل الجديد
    $stat = Stat::create([
        'show_stats' => $request->show_stats,
        'stats_heading' => $request->stats_heading,
        'description' => $request->description,
    ]);

        return response()->json($stat, 201);
    }

    // دالة لتحديث بيانات الإحصائيات
    public function updateStats(Request $request, $id)
    {
        $stat = Stat::find($id);

        if (!$stat) {
            return response()->json([
                'message' => 'البيانات غير موجودة.'
            ], 404);
        }

        $request->validate([
            'show_stats' => 'required|boolean',
            'stats_heading' => 'required|string|max:255',
            'description' => 'required|string|max:255',
        ]);

        $stat->update([
            'show_stats' => $request->show_stats,
            'stats_heading' => $request->stats_heading,
             'description' => $request->description,
        ]);

        return response()->json($stat);
    }

    // دالة لحذف بيانات الإحصائيات
    public function deleteStats($id)
    {
        $stat = Stat::find($id);

        if (!$stat) {
            return response()->json([
                'message' => 'البيانات غير موجودة.'
            ], 404);
        }

        $stat->delete();

        return response()->json([
            'message' => 'تم حذف البيانات بنجاح.'
        ], 200);
    }
}
