<?php

// app/Http/Controllers/SupportController.php

namespace App\Http\Controllers;

use App\Models\Support;
use Illuminate\Http\Request;

class SupportController extends Controller
{
    // عرض جميع طلبات الدعم
    public function index()
    {
        return Support::all();
    }

    // إنشاء طلب دعم جديد
    public function store(Request $request)
    {
        $request->validate([
            'title' => 'required|string|max:255',
            'type' => 'required|string|max:100',
            'status' => 'required|string',
        ]);

        $support = Support::create($request->all());
        return response()->json($support, 201);
    }

    // عرض طلب دعم معين
    public function show($id)
    {
        return Support::findOrFail($id);
    }

    // تحديث طلب دعم معين
    public function update(Request $request, $id)
    {
        $support = Support::findOrFail($id);
        $support->update($request->all());
        return response()->json($support, 200);
    }

    // حذف طلب دعم معين
    public function destroy($id)
    {
        Support::findOrFail($id)->delete();
        return response()->json(null, 204);
    }
}
