<?php

namespace App\Http\Controllers;

use App\Models\Volunteer;
use Illuminate\Http\Request;
use App\Http\Resources\VolunteerResource;

class VolunteerController extends Controller
{
    /**
     * Store a newly created volunteer in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        // Validate the request data
        $request->validate([
            'full_name' => 'required|string|max:255',
            'birth_date' => 'required|date',
            'work_study_level' => 'required|string|max:255',
            'affiliated_entity' => 'required|string|max:255',
            'email' => 'required|string|email|max:255|unique:volunteers',
            'mobile_number' => 'required|string|max:15',
            'request_date' => 'required|date',
            'request_image' => 'required|image|max:2048'
        ]);
    
        if ($request->hasFile('request_image')) {
            $file = $request->file('request_image');
            $path = $file->store('public/request_images');
            $path = str_replace('public/', '', $path);
            $volunteer = Volunteer::create([
                'full_name' => $request->input('full_name'),
                'birth_date' => $request->input('birth_date'),
                'work_study_level' => $request->input('work_study_level'),
                'affiliated_entity' => $request->input('affiliated_entity'),
                'email' => $request->input('email'),
                'mobile_number' => $request->input('mobile_number'),
                'request_date' => $request->input('request_date'),
                'request_image' => $path,
            ]);
    
            return response()->json([
                'message' => 'Volunteer created successfully',
                'volunteer' => $volunteer
            ], 201);
        } else {
            return response()->json([
                'message' => 'Request image file is required'
            ], 400);
        }
    }
    

    /**
     * Display a listing of the volunteers.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
    $volunteers = Volunteer::all();

    return VolunteerResource::collection($volunteers);
    }
}
