<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Payment extends Model
{
    use HasFactory;

    protected $fillable = [
        'card_number',
        'name_on_card',
        'phone',
        'amount',
        'project_id',
        'campaign_id',
        'tracking_link_id',
        'donor_id',
        'status',
          'payment_gateway_id',
             'gateway_response', // للحفظ هنا
        'token', 
           'next_donation_at', // تاريخ التبرع القادم
        'frequency_interval', 
        'token', 
        'created_at',
        'updated_at'
    ];
    
    protected $casts = [
    'gateway_response' => 'array',
  
];


    // Define the relationship with Project
    public function project()
    {
        return $this->belongsTo(Project::class);
    }

    // Define the relationship with Campaign
    public function campaign()
    {
        return $this->belongsTo(Campaign::class);
    }

    // Define the relationship with TrackingLink
    public function trackingLink()
    {
        return $this->belongsTo(TrackingLink::class);
    }

    // Define the relationship with User (Donor)
    public function donor()
    {
        return $this->belongsTo(User::class, 'donor_id');
    }
}
