<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class RecurringDonation extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id', // إضافة user_id
        'amount',
        'currency',
        'token',
        'frequency',
        'next_donation_date',
        'last_donated_at',
        'phone',
    ];

    protected $casts = [
        'next_donation_date' => 'datetime', // تحويل next_donation_date إلى كائن Carbon
        'last_donated_at' => 'datetime', // تحويل last_donated_at إلى كائن Carbon
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    // علاقة مع نموذج Project
    public function project()
    {
        return $this->belongsTo(Project::class);
    }

    // علاقة مع نموذج TrackingLink
    public function trackingLink()
    {
        return $this->belongsTo(TrackingLink::class);
    }

    // علاقة مع نموذج Campaign
    public function campaign()
    {
        return $this->belongsTo(Campaign::class);
    }
}
