<?php

// app/Models/TrackingLink.php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TrackingLink extends Model
{
    use HasFactory;

      protected $fillable = [
        'title', 
        'custom_keyword', 
        'added_date', 
        'visits', 
        'new_donors', 
        'donation_transactions', 
        'donations', 
        'purchases_count', // أضف هذا السطر
        'url', 
        'donations',
        'is_archived', 
        'coordinator_id',
         'advertiser_email',
         'advertiser_phone',
         'advertiser_name'
    ];


    // Relationship with coordinator
    public function coordinator()
    {
        return $this->belongsTo(Coordinator::class);
    }
    public function payments()
    {
        return $this->hasMany(Payment::class);
    }
    
}
