<?php


namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class WaqfCertificate extends Model
{
    use HasFactory;

    protected $fillable = [
        'name', 
        'amount', 
        'issued_by', 
        'banner_image'
    ];

    
    public static function boot()
    {
        parent::boot();

        static::creating(function ($model) {
            if ($model->amount < 1000) {
                throw new \Exception('The amount must be at least 1000.');
            }
        });
    }

   
    public function donor()
    {
        return $this->belongsTo(User::class, 'issued_by');
    }
}
