<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateVolunteersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('volunteers', function (Blueprint $table) {
            $table->id();
            $table->string('full_name'); // الاسم الثلاثي
            $table->date('birth_date'); // تاريخ الميلاد
            $table->string('work_study_level'); // العمل/المستوى الدراسي
            $table->string('affiliated_entity'); // الجهة التابعة لها
            $table->string('email')->unique(); // البريد الالكتروني
            $table->string('mobile_number'); // رقم الجوال
            $table->date('request_date'); // تاريخ الطلب
            $table->string('request_image'); // صورة الطلب
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('volunteers');
    }
}
