<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateAssociationsTable extends Migration
{
    public function up()
    {
        Schema::create('associations', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('licenseNumber');
            $table->string('licenseImage')->nullable();
            $table->date('licenseExpiryDate')->nullable();
            $table->string('postNumber');
            $table->string('address');
            $table->string('phone');
            $table->string('city');
            $table->string('website')->nullable();
            $table->string('email')->unique();
            $table->string('storeVerificationLink')->nullable();
            $table->string('storeAuthenticationImage')->nullable();
            $table->string('facebookAccount')->nullable();
            $table->string('twitterAccount')->nullable();
            $table->string('youtubeAccount')->nullable();
            $table->string('instagramAccount')->nullable();
            $table->string('snapchatAccount')->nullable();
            $table->string('whatsApp')->nullable();
            $table->text('shortDescription')->nullable();
            $table->text('siteFooterText')->nullable();
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('associations');
    }
}
