<?php

// database/migrations/xxxx_xx_xx_xxxxxx_create_tracking_links_table.php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTrackingLinksTable extends Migration
{
    public function up()
    {
        Schema::create('tracking_links', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->string('advertiser_name');
            $table->string('advertiser_phone');
            $table->string('advertiser_email');
            $table->string('custom_keyword');
            $table->date('added_date');
            $table->unsignedBigInteger('visits')->default(0);
            $table->unsignedBigInteger('new_donors')->default(0);
            $table->unsignedBigInteger('donation_transactions')->default(0);
            $table->unsignedBigInteger('donations')->default(0);
            $table->string('url');
            $table->boolean('is_archived')->default(false);
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('tracking_links');
    }
}
