<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
public function up()
{
    Schema::table('tracking_links', function (Blueprint $table) {
        // فقط أضف الأعمدة إذا لم تكن موجودة بالفعل
        if (!Schema::hasColumn('tracking_links', 'donation_transactions')) {
            $table->integer('donation_transactions')->default(0);
        }
        
        if (!Schema::hasColumn('tracking_links', 'donations')) {
            $table->decimal('donations', 10, 2)->default(0.00);
        }
    });
}

public function down()
{
    Schema::table('tracking_links', function (Blueprint $table) {
        // حذف الأعمدة إذا كانت موجودة
        if (Schema::hasColumn('tracking_links', 'donation_transactions')) {
            $table->dropColumn('donation_transactions');
        }
        
        if (Schema::hasColumn('tracking_links', 'donations')) {
            $table->dropColumn('donations');
        }
    });
}


};
