<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
       Schema::create('hadiyas', function (Blueprint $table) {
    $table->id();
    $table->string('gift_type');
    $table->string('card_design');
    $table->string('recipient_name');
    $table->string('recipient_phone');
    $table->string('sender_name');
    $table->string('sender_phone');
    $table->boolean('send_card_to_sender')->default(false);
    $table->decimal('amount', 10, 2);
    $table->timestamps();
});

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('hadiyas');
    }
};
