<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
public function up()
{
    Schema::create('pages', function (Blueprint $table) {
        $table->id();
        $table->string('title');      // عنوان الصفحة
        $table->string('page');       // اسم الصفحة
        $table->json('content');      // المحتوى كـ JSON يشمل النص والصور/الفيديو
         $table->text('project_id')->nullable();
        $table->timestamps();
    });
}


    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('pages');
    }
};
