<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
public function up()
{
    Schema::create('targets', function (Blueprint $table) {
        $table->id();
        $table->string('target_name'); // إسم المستهدف
        $table->decimal('target_amount', 10, 2); // المبلغ المستهدف
        $table->date('date'); // تاريخ الإنشاء
        $table->enum('status', ['active', 'inactive']); // الحالة
        $table->json('target_settings')->nullable(); // إعدادات المستهدف
        $table->timestamps(); // إضافة timestamps
    });
}




    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('targets');
    }
};
