<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
Schema::create('recurring_donations', function (Blueprint $table) {
    $table->id();
    $table->unsignedBigInteger('client_id'); // ارتباط بالعميل
    $table->decimal('amount', 8, 2);
    $table->string('currency')->default('SAR');
    $table->string('token');
    $table->enum('frequency', ['daily', 'weekly', 'monthly']);
    $table->timestamp('next_donation_date'); // تاريخ التبرع القادم
    $table->timestamps();

    // علاقة بالعميل
    $table->foreign('client_id')->references('id')->on('clients')->onDelete('cascade');
});

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('recurring_donations');
    }
};
