<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
// database/migrations/xxxx_xx_xx_xxxxxx_create_project_requests_table.php

public function up()
{
    Schema::create('project_requests', function (Blueprint $table) {
        $table->id();
        $table->string('name');
        $table->string('phone');
        $table->string('city');
        $table->string('project');
        $table->decimal('amount', 15, 2);
        $table->date('startDate');
        $table->date('endDate');
        $table->timestamps();
    });
}

public function down()
{
    Schema::dropIfExists('project_requests');
}

};
