<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Category extends Model
{
    use HasFactory;

    // تحديد الجدول الذي يرتبط به هذا النموذج
    protected $table = 'categories';

    protected $fillable = ['name', 'is_visible', 'image', 'banner_image'];


    // تعريف العلاقة مع نموذج المشاريع
    public function projects()
    {
        return $this->hasMany(Project::class);
    }
}
