<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Project extends Model
{
    use HasFactory;


protected $fillable = [
    'category_id', 'title', 'totalMoney', 'gained', 'imgSrc', 'description',
    'beneficiaries_count', 'target_count', 'start_date', 'end_date', 'is_visible',
    'show_percentage', 'show_gained', 'show_totalMoney', 'sahm_cart', 'sahm_quick',
    'participantName', 'amount', 'deduction_period', 'deduction_end_date',
    'seo_keywords', 'seo_description', 'related_project_ids', 'showSahm',
    'cart_donation_type', 'quick_donation_type', 'cart_deduction_date',
    'quick_deduction_date', 'specified_amount', 'sort'
];



    protected $casts = [
        'totalMoney' => 'decimal:2',
        'gained' => 'decimal:2',
          'specified_amount' => 'decimal:2',
        'percentage' => 'decimal:2',
        'show_percentage' => 'boolean',
        'show_gained' => 'boolean',
        'show_totalMoney' => 'boolean',
        'is_visible' => 'boolean',
        'sahm_cart' => 'array', // تحويل sahm_cart إلى array
        'sahm_quick' => 'array', // تحويل sahm_quick إلى array
        'related_project_ids' => 'array', // تحويل related_project_ids إلى array
    ];

    public function payments()
    {
        return $this->hasMany(Payment::class);
    }

    public function category()
    {
        return $this->belongsTo(Category::class, 'category_id');
    }

    public function incrementVisits($id)
    {
        $project = Project::findOrFail($id);
        $project->increment('visits');
        return response()->json(['message' => 'Visit counted successfully', 'visits' => $project->visits]);
    }

public function calculatePercentageValues($manualGained = null)
{
    // إذا تم تمرير قيمة يدوية لـ gained، استخدمها
    if ($manualGained !== null) {
        $this->gained = $manualGained;
    } else {
        // إذا لم يتم تمرير قيمة يدوية، احسب gained من المدفوعات
        $this->gained = $this->payments()->sum('amount');
    }

    // حساب النسبة بناءً على القيمة الحالية لـ gained
    $totalMoney = $this->totalMoney;

    if ($totalMoney > 0) {
        $calculatedPercentage = ($this->gained / $totalMoney) * 100;
        $this->percentage = number_format($calculatedPercentage, 2);
    } else {
        $this->percentage = 0;
    }

    // حفظ التحديثات
    $this->save();
}
}

