<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Association;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Validator;

class AssociationController extends Controller
{
public function index()
{
    $associations = Association::all();

    // تعديل مسارات الصور في الاستجابة
    foreach ($associations as $association) {
        if ($association->licenseImage) {
            // إرجاع المسار الكامل للصورة
            $association->licenseImage = url('storage/' . $association->licenseImage);
        }
        if ($association->storeAuthenticationImage) {
            // إرجاع المسار الكامل لصورة التوثيق
            $association->storeAuthenticationImage = url('storage/' . $association->storeAuthenticationImage);
        }
        if ($association->store_certificate) {
            // إرجاع المسار الكامل لشهادة المتجر
            $association->store_certificate = url('storage/' . $association->store_certificate);
        }
    }

    return response()->json($associations);
}



public function store(Request $request)
{
    \Log::info('Request Data:', $request->all());

    // تحقق من وجود السجل القديم وحذفه
    Association::truncate(); // حذف جميع السجلات من جدول associations

    // التحقق من صحة البيانات مع رسائل خطأ مخصصة
    $validator = Validator::make($request->all(), [
        'name' => 'required|string|max:255',
        'licenseNumber' => 'nullable|string|max:255',
        'licenseImage' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:2048',
        'licenseExpiryDate' => 'nullable|date',
        'postNumber' => 'nullable|string|max:255',
        'address' => 'nullable|string|max:255',
        'phone' => 'nullable|string|max:255',
        'city' => 'nullable|string|max:255',
        'website' => 'nullable|string|max:255',
        'email' => 'nullable|email|max:255',
        'storeVerificationLink' => 'nullable|string|max:255',
        'storeAuthenticationImage' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:2048',
        'titleFont' => 'nullable|string|max:255',
        'facebookAccount' => 'nullable|string|max:255',
        'twitterAccount' => 'nullable|string|max:255',
        'youtubeAccount' => 'nullable|string|max:255',
        'instagramAccount' => 'nullable|string|max:255',
        'snapchatAccount' => 'nullable|string|max:255',
        'whatsApp' => 'nullable|string|max:255',
        'shortDescription' => 'nullable|string',
        'siteFooterText' => 'nullable|string',
        'latitude' => 'nullable|numeric',
        'longitude' => 'nullable|numeric',
        'store_certificate' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:2048',  // تعديل هنا: جعل الصورة قابلة للرفع
        'store_certificate_url' => 'nullable|string|max:255',
    ], [
        'store_certificate.image' => 'يجب أن يكون الحقل صورة.',
        'store_certificate.mimes' => 'يجب أن تكون الصورة من الأنواع: jpeg, png, jpg, gif.',
        'store_certificate.max' => 'يجب ألا يتجاوز حجم الصورة 2 ميجابايت.',
    ]);

    if ($validator->fails()) {
        return response()->json(['errors' => $validator->errors()], 422);
    }

    // إنشاء سجل جديد
    $association = new Association($request->except(['licenseImage', 'storeAuthenticationImage', 'store_certificate', 'store_certificate_url']));

    // تعيين قيمة titleFont إذا كانت موجودة
    $association->titleFont = $request->input('titleFont', null);

    if ($request->hasFile('licenseImage')) {
        $path = $request->file('licenseImage')->store('public/licenses');
        \Log::info('License Image Path: ' . $path);
        $association->licenseImage = str_replace('public/', '', $path);
    }

    if ($request->hasFile('storeAuthenticationImage')) {
        $path = $request->file('storeAuthenticationImage')->store('public/auth_images');
        \Log::info('Store Authentication Image Path: ' . $path);
        $association->storeAuthenticationImage = str_replace('public/', '', $path);
    }

    // إضافة الحقل store_certificate كصورة
    if ($request->hasFile('store_certificate')) {
        $path = $request->file('store_certificate')->store('public/certificates');
        \Log::info('Store Certificate Path: ' . $path);
        $association->store_certificate = str_replace('public/', '', $path);
    }

    // إضافة الحقل store_certificate_url إذا كان موجود
    $association->store_certificate_url = $request->input('store_certificate_url', null);

    // حفظ السجل
    $association->save();

    return response()->json($association, 201);
}




public function update(Request $request, $id)
{
    \Log::info('Request Data:', $request->all());

    // التحقق من صحة البيانات مع رسائل خطأ مخصصة
    $validator = Validator::make($request->all(), [
        'name' => 'nullable|string|max:255',
        'licenseNumber' => 'nullable|string|max:255',
        'licenseImage' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:2048',
        'licenseExpiryDate' => 'nullable|date',
        'postNumber' => 'nullable|string|max:255',
        'address' => 'nullable|string|max:255',
        'phone' => 'nullable|string|max:255',
        'city' => 'nullable|string|max:255',
        'website' => 'nullable|string|max:255',
        'email' => 'nullable|email|max:255',
        'storeVerificationLink' => 'nullable|string|max:255',
        'storeAuthenticationImage' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:2048',
        'titleFont' => 'nullable|string|max:255',
        'facebookAccount' => 'nullable|string|max:255',
        'twitterAccount' => 'nullable|string|max:255',
        'youtubeAccount' => 'nullable|string|max:255',
        'instagramAccount' => 'nullable|string|max:255',
        'snapchatAccount' => 'nullable|string|max:255',
        'whatsApp' => 'nullable|string|max:255',
        'shortDescription' => 'nullable|string',
        'siteFooterText' => 'nullable|string',
        'latitude' => 'nullable|numeric', 
        'longitude' => 'nullable|numeric',
        'store_certificate' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:2048', // تعديل هنا: جعل الصورة قابلة للرفع
        'store_certificate_url' => 'nullable|string|max:255',
    ], [
        'store_certificate.image' => 'يجب أن يكون الحقل صورة.',
        'store_certificate.mimes' => 'يجب أن تكون الصورة من الأنواع: jpeg, png, jpg, gif.',
        'store_certificate.max' => 'يجب ألا يتجاوز حجم الصورة 2 ميجابايت.',
    ]);

    if ($validator->fails()) {
        \Log::info('Validation Errors:', $validator->errors()->toArray());
        return response()->json(['errors' => $validator->errors()], 422);
    }

    $association = Association::findOrFail($id);
    \Log::info('Association Before Update:', ['association' => $association->toArray()]);
    
    $association->fill($request->except(['licenseImage', 'storeAuthenticationImage', 'store_certificate']));

    // تحديث قيمة titleFont إذا كانت موجودة
    $association->titleFont = $request->input('titleFont', $association->titleFont);

    if ($request->hasFile('licenseImage')) {
        if ($association->licenseImage) {
            Storage::delete($association->licenseImage);
        }
        $path = $request->file('licenseImage')->store('public/licenses');
        \Log::info('License Image Path: ' . $path);
        $association->licenseImage = str_replace('public/', '', $path);
    }

    if ($request->hasFile('storeAuthenticationImage')) {
        if ($association->storeAuthenticationImage) {
            Storage::delete($association->storeAuthenticationImage);
        }
        $path = $request->file('storeAuthenticationImage')->store('public/auth_images');
        \Log::info('Store Authentication Image Path: ' . $path);
        $association->storeAuthenticationImage = str_replace('public/', '', $path);
    }

    // تحديث الحقل store_certificate كصورة
    if ($request->hasFile('store_certificate')) {
        if ($association->store_certificate) {
            Storage::delete($association->store_certificate);
        }
        $path = $request->file('store_certificate')->store('public/certificates');
        \Log::info('Store Certificate Path: ' . $path);
        $association->store_certificate = str_replace('public/', '', $path);
    }

    // تحديث الحقل store_certificate_url إذا كان موجود
    $association->store_certificate_url = $request->input('store_certificate_url', $association->store_certificate_url);

    $association->save();
    \Log::info('Association After Save:', ['association' => $association->toArray()]);

    return response()->json($association, 200);
}







    public function destroy($id)
    {
        $association = Association::findOrFail($id);

        // حذف الصور من التخزين إذا كانت موجودة
        if ($association->licenseImage) {
            Storage::delete($association->licenseImage);
        }

        if ($association->storeAuthenticationImage) {
            Storage::delete($association->storeAuthenticationImage);
        }

        $association->delete();

        return response()->json(null, 204);
    }
}
