<?php

namespace App\Http\Controllers;

use App\Models\Color;
use Illuminate\Http\Request;

class ColorController extends Controller
{
    public function index()
    {
        return response()->json(Color::first());
    }

    public function update(Request $request)
    {
        $request->validate([
            'siteColor' => 'required|string',
            'adminColor' => 'required|string',
            'bodyColor' => 'required|string',
            'buttonColor' => 'required|string',
        ]);

        $color = Color::first();
        if (!$color) {
            $color = new Color();
        }

        $color->siteColor = $request->input('siteColor');
        $color->adminColor = $request->input('adminColor');
        $color->bodyColor = $request->input('bodyColor');
        $color->buttonColor = $request->input('buttonColor');
        $color->save();

        return response()->json($color);
    }
}

