<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Controllers\EditMainPageController;
use App\Models\EditMainPage;



class EditMainPageController extends Controller
{
    /**
     * Display a listing of the resource.
     */
public function index()
{
    return response()->json(EditMainPage::all());
}

public function store(Request $request)
{
    $request->validate([
        'video_url' => 'nullable|string',
        'projects_show' => 'boolean',
        'banner_show' => 'boolean',
        'show_in_seconds' => 'nullable|integer',
    ]);

    $editPage = EditMainPage::create($request->all());
    return response()->json($editPage, 201);
}

public function update(Request $request, $id)
{
    // التحقق من البيانات المدخلة
    $request->validate([
        'video_url' => 'nullable|string',
        'projects_show' => 'nullable|boolean',
        'banner_show' => 'nullable|boolean',
        'show_in_seconds' => 'nullable|integer',
    ]);

    // العثور على الصفحة باستخدام المعرف (ID)
    $editPage = EditMainPage::findOrFail($id);

    // تحديث الحقول فقط إذا كانت موجودة في الطلب
    if ($request->has('video_url')) {
        $editPage->video_url = $request->input('video_url');
    }
    if ($request->has('projects_show')) {
        $editPage->projects_show = $request->input('projects_show');
    }
    if ($request->has('banner_show')) {
        $editPage->banner_show = $request->input('banner_show');
    }
    if ($request->has('show_in_seconds')) {
        $editPage->show_in_seconds = $request->input('show_in_seconds');
    }

    // حفظ التحديثات في قاعدة البيانات
    $editPage->save();

    // إرجاع استجابة JSON مع البيانات المعدلة
    return response()->json($editPage);
}


public function destroy($id)
{
    EditMainPage::findOrFail($id)->delete();
    return response()->json(['message' => 'Deleted successfully']);
}

}
