<?php

namespace App\Http\Controllers;

use App\Models\GiftCard;

use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Validator;

class GiftCardController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(): JsonResponse
    {
        $gifts = GiftCard::all();
        return response()->json($gifts);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request): JsonResponse
    {
        // قم بتعريف قواعد التحقق
        $validator = Validator::make($request->all(), [
            'recipientName' => 'required|string|max:255',
            'recipientNumber' => 'required|string|max:15', // تغيير الحد الأقصى حسب الحاجة
            'senderName' => 'required|string|max:255',
            'senderNumber' => 'required|string|max:15', // تغيير الحد الأقصى حسب الحاجة
            'amount' => 'required|numeric|min:1',
            'sendCardToSenderOption' => 'required|boolean',
        ]);

        // تحقق من صحة البيانات
        if ($validator->fails()) {
            return response()->json(['errors' => $validator->errors()], 422);
        }

        // قم بإنشاء سجل التبرع
        $gift = GiftCard::create($request->all());

        return response()->json($gift, 201);
    }

    /**
     * Display the specified resource.
     */
    public function show(Gift $gift): JsonResponse
    {
        return response()->json($gift);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Gift $gift): JsonResponse
    {
        $validator = Validator::make($request->all(), [
            'recipientName' => 'string|max:255',
            'recipientNumber' => 'string|max:15',
            'senderName' => 'string|max:255',
            'senderNumber' => 'string|max:15',
            'amount' => 'numeric|min:1',
            'sendCardToSenderOption' => 'boolean',
        ]);

        if ($validator->fails()) {
            return response()->json(['errors' => $validator->errors()], 422);
        }

        $gift->update($request->all());
        return response()->json($gift);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Gift $gift): JsonResponse
    {
        $gift->delete();
        return response()->json(null, 204);
    }
}
