<?php

// app/Http/Controllers/MessageController.php

namespace App\Http\Controllers;
use App\Models\User;

use App\Models\GroupMessage;
use App\Services\MessageGatewayService;
use Illuminate\Http\Request;

class GroupMessagesController extends Controller
{
    protected $messageGateway;

    public function __construct(MessageGatewayService $messageGateway)
    {
        $this->messageGateway = $messageGateway;
    }

 public function send(Request $request)
{
    // Validate the data
    $request->validate([
        'sender_name' => 'required|string|max:255',
        'type' => 'required|in:text,email',
        'content' => 'required|string',
        'recipients' => 'required|array', // This field now contains an array of recipient objects
        'recipients.*.user_id' => 'required|exists:users,id', // Ensure that user_id exists in the users table
        'recipients.*.name' => 'required|string|max:255', // Ensure each recipient has a name
        'recipients.*.phone' => 'required|string', // Ensure each recipient has a phone number
    ]);

    // Store the message in the database
    $message = GroupMessage::create([
        'sender_name' => $request->sender_name,
        'type' => $request->type,
        'content' => $request->content,
    ]);

    // Send the message to each recipient
    foreach ($request->recipients as $recipientData) {
        $recipient = User::find($recipientData['user_id']);
        $phone = $recipientData['phone']; // Now using the provided phone number from the input

        if ($message->type === 'email') {
            // Send email
            \Mail::raw($message->content, function($mail) use ($recipient, $message) {
                $mail->to($recipient->email)
                     ->subject('رسالة جديدة من ' . $message->sender_name);
            });
        } else {
            // Use MessageGatewayService to send text messages
            $response = $this->messageGateway->sendThankYouMessage($phone, $message->sender_name, $message->content);

            if (!$response['success']) {
                return response()->json([
                    'message' => 'فشل في إرسال الرسائل',
                    'error' => $response['error'],
                ], 500);
            }
        }
    }

    return response()->json(['message' => 'تم إرسال الرسالة بنجاح']);
}

    
       public function index()
    {
        // استرجاع جميع الرسائل الجماعية من قاعدة البيانات
        $messages = GroupMessage::all();

        // إرجاع الرسائل كاستجابة JSON
        return response()->json($messages);
    }
}

