<?php

namespace App\Http\Controllers;

use App\Models\Link;
use Illuminate\Http\Request;

class LinkController extends Controller
{
    public function index()
    {
        $links = Link::all();
        return response()->json($links);
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'العنوان' => 'required|string',
            'الرابط' => 'required|string',
            'QrCodePing' => 'required|string',
        ]);

        $link = Link::create($validated);
        return response()->json($link, 201);
    }

    public function show($id)
    {
        $link = Link::findOrFail($id);
        return response()->json($link);
    }

    public function update(Request $request, $id)
    {
        $validated = $request->validate([
            'العنوان' => 'string',
            'الرابط' => 'string',
            'QrCodePing' => 'string',
        ]);

        $link = Link::findOrFail($id);
        $link->update($validated);
        return response()->json($link);
    }

    public function destroy($id)
    {
        $link = Link::findOrFail($id);
        $link->delete();
        return response()->json(null, 204);
    }
}

