<?php



namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Setting;

class SettingsController extends Controller
{
    public function index()
    {
        $settings = Setting::first();
        return response()->json($settings);
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            'googleAnalytics' => 'nullable|string',
            'chatCode' => 'nullable|string',
            'whatsappScript' => 'nullable|string',
            'googleTagManagerHead' => 'nullable|string',
            'googleTagManagerBody' => 'nullable|string',
            'facebookPixelId' => 'nullable|string',
            'facebookCatalogLink' => 'nullable|string',
            'twitterWebsiteTag' => 'nullable|string',
            'snapshotPixelId' => 'nullable|string',
            'snapshotCatalogLink' => 'nullable|string',
            'hotgarScriptHeader' => 'nullable|string',
            'tiktokPixelId' => 'nullable|string',
            'tiktokCatalogLink' => 'nullable|string',
        ]);

        $setting = Setting::first();
        if ($setting) {
            $setting->update($data);
        } else {
            $setting = Setting::create($data);
        }

        return response()->json($setting);
    }

    public function show($id)
    {
        $setting = Setting::findOrFail($id);
        return response()->json($setting);
    }

    public function update(Request $request, $id)
    {
        $data = $request->validate([
            'googleAnalytics' => 'nullable|string',
            'chatCode' => 'nullable|string',
            'whatsappScript' => 'nullable|string',
            'googleTagManagerHead' => 'nullable|string',
            'googleTagManagerBody' => 'nullable|string',
            'facebookPixelId' => 'nullable|string',
            'facebookCatalogLink' => 'nullable|string',
            'twitterWebsiteTag' => 'nullable|string',
            'snapshotPixelId' => 'nullable|string',
            'snapshotCatalogLink' => 'nullable|string',
            'hotgarScriptHeader' => 'nullable|string',
            'tiktokPixelId' => 'nullable|string',
            'tiktokCatalogLink' => 'nullable|string',
        ]);

        $setting = Setting::findOrFail($id);
        $setting->update($data);

        return response()->json($setting);
    }

    public function destroy($id)
    {
        $setting = Setting::findOrFail($id);
        $setting->delete();

        return response()->json(['message' => 'Setting deleted successfully']);
    }
}
