<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Text;

class TextController extends Controller
{
    public function index()
    {
        return response()->json(Text::all());
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string',
            'old' => 'required|string',
            'new' => 'required|string',
        ]);

   
        // إنشاء الإدخال الجديد
        $text = Text::create($request->all());

        return response()->json($text, 201);
    }

public function update(Request $request, $id)
{
    // التحقق من البيانات المدخلة
    $request->validate([
        'name' => 'nullable|string',  // التحقق إذا تم إرسال اسم
        'old' => 'nullable|string',   // التحقق إذا تم إرسال القيمة القديمة
        'new' => 'nullable|string',   // التحقق إذا تم إرسال القيمة الجديدة
    ]);

    // العثور على النص باستخدام المعرف (ID)
    $text = Text::findOrFail($id);

    // تحديث الحقول فقط إذا كانت موجودة في الطلب
    if ($request->has('name')) {
        $text->name = $request->input('name');
    }
    if ($request->has('old')) {
        $text->old = $request->input('old');
    }
    if ($request->has('new')) {
        $text->new = $request->input('new');
    }

    // حفظ التحديثات في قاعدة البيانات
    $text->save();

    // إرجاع استجابة JSON مع البيانات المعدلة
    return response()->json($text);
}


    public function destroy($id)
    {
        Text::findOrFail($id)->delete();
        return response()->json(['message' => 'Deleted successfully']);
    }
}
