<?php

namespace App\Http\Controllers;


use Illuminate\Http\Request;
use App\Http\Controllers\WebsitePageController;
use App\Models\WebsitePage;


class WebsitePageController extends Controller
{
    /**
     * Display a listing of the resource.
     */
public function index()
{
    return response()->json(WebsitePage::all());
}

public function store(Request $request)
{
    $request->validate([
        'title' => 'required|string',
        'banner' => 'nullable|string',
        'content' => 'nullable|string',
        'show_in_main_menu' => 'boolean',
        'show_in_footer_menu' => 'boolean',
    ]);

    $page = WebsitePage::create($request->all());
    return response()->json($page, 201);
}

public function update(Request $request, $id)
{
    $page = WebsitePage::findOrFail($id);
    $page->update($request->all());
    return response()->json($page);
}

public function destroy($id)
{
    WebsitePage::findOrFail($id)->delete();
    return response()->json(['message' => 'Deleted successfully']);
}

}
