<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\ProjectController;
use App\Http\Controllers\DonationController;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\ImageController;
use Spatie\FlareClient\Api;
use App\Http\Controllers\PaymentController;
use Illuminate\Support\Facades\Hash;
use App\Http\Controllers\GiftCardController;
use App\Http\Controllers\LogoController;
use App\Http\Controllers\MetalPriceController;
use App\Http\Controllers\MessageController;
use App\Http\Controllers\LinkController;
use App\Http\Controllers\AboutUsController;
use App\Http\Controllers\VolunteerController;
use App\Http\Controllers\SmsMessageController;
use App\Http\Controllers\PartnerController;
use App\Http\Controllers\SysNotificationController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\AssociationController;
use App\Http\Controllers\ContactInfoController;
use App\Http\Controllers\RepairController;
use App\Http\Controllers\SettingsController;
use App\Http\Controllers\IntegrationController;
use App\Http\Controllers\GiftController;
use App\Http\Controllers\BankAccountController;
use App\Http\Controllers\CategoryController;
use App\Http\Controllers\SeoSettingController;
use App\Http\Controllers\TrackingLinkController;
use App\Http\Controllers\CampaignController;
use App\Http\Controllers\ColorController;
use App\Http\Controllers\HadiyaController;
use App\Http\Controllers\WaqfCertificateController;
use App\Http\Controllers\CoordinatorController;
use App\Http\Controllers\PageController;
use App\Http\Controllers\AbandonedCartController;
use App\Http\Controllers\TargetController;
use App\Http\Controllers\WaqfyaController;
use App\Http\Controllers\MessageControlController;
use App\Http\Controllers\TextController;
use App\Http\Controllers\WebsitePageController;
use App\Http\Controllers\EditMainPageController;
use App\Http\Controllers\QrCodeController;
use App\Http\Controllers\WaqfyaDataController;
use App\Http\Controllers\PartnerssController;
use App\Console\Commands\ProcessRecurringDonations;









Route::get('/test-process-recurring-donations', function () {
    Artisan::call('donations:process-recurring');
    return response()->json(['message' => 'Recurring donations processed successfully']);
});

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

Route::post('/payment', [PaymentController::class, 'processPayment']);
Route::get('/payment/{id}', [PaymentController::class, 'showPayment']);
Route::get('/payments', [PaymentController::class, 'getAllPayments']);

use App\Http\Controllers\RecurringDonationController;

// Route لإنشاء توكن
Route::post('/recurring-donations/create-token', [RecurringDonationController::class, 'createToken']);

// Route لمعالجة التبرع
Route::post('/recurring-donations/process', [RecurringDonationController::class, 'processDonation']);

// Route لتسجيل التبرع الدوري
Route::post('/recurring-donations/register', [RecurringDonationController::class, 'registerRecurringDonation']);



Route::group([
    'middleware' => 'api',
    'prefix' => 'auth'
], function ($router) {
    Route::post('/login', [AuthController::class, 'login']);
    Route::post('/register', [AuthController::class, 'register']);
    Route::post('admin/register', [AuthController::class, 'adminRegister']);
    Route::post('admin/login', [AuthController::class, 'adminLogin']);
    Route::post('/logout', [AuthController::class, 'logout']);
    Route::post('/refresh', [AuthController::class, 'refresh']);
    Route::get('/user-profile', [AuthController::class, 'userProfile']);
    
    Route::get('users', [AuthController::class, 'getAllUsers']);


  Route::post('/change-role', [AuthController::class, 'changeUserRole']);

    Route::get('/all-users', [AuthController::class, 'userProfile'])->middleware("adminmiddleware");

 








});

   //Volunteers
    Route::post('/volunteers/add', [VolunteerController::class, 'store']);
    Route::get('/volunteers', [VolunteerController::class, 'index']);

    //Sms Msg
    Route::post('/sms-messages/add', [SmsMessageController::class, 'store']);
    Route::get('/sms-messages', [SmsMessageController::class, 'index']);

    // Partners
    Route::get('/partners', [PartnerController::class, 'index']);
    Route::post('/partners/add', [PartnerController::class, 'store']);


    //Sys Notification
    Route::get('/notifications', [SysNotificationController::class, 'index']);
    Route::post('/notifications/add', [SysNotificationController::class, 'store']);

    //users
    Route::get('/users', [UserController::class, 'index']);





Route::middleware(['jwt.verify'])->group(function () {
    
});

Route::post('projects', [ProjectController::class, 'store'])->middleware("adminmiddleware");

Route::get('/images', [ImageController::class, 'index']);
Route::get('/images/{id}', [ImageController::class, 'show']);
Route::post('/images', [ImageController::class, 'store']);

Route::delete('/images/{id}', [ImageController::class, 'destroy']);
Route::post('/images/{id}', [ImageController::class, 'update']);


Route::post('/giftcards', [GiftCardController::class, 'store']);
Route::get('/giftcards', [GiftCardController::class, 'index']);

Route::get('/logos', [LogoController::class, 'index']);
Route::get('/logos/{id}', [LogoController::class, 'show']);
Route::post('/logos', [LogoController::class, 'store']);
Route::put('/logos/{id}', [LogoController::class, 'update']);
Route::delete('/logos/{id}', [LogoController::class, 'destroy']);

Route::get('projects/{id}', [ProjectController::class, 'show']);
Route::get('projects', [ProjectController::class, 'index']);
Route::post('donations', [DonationController::class, 'store'])->middleware("adminmiddleware");
Route::match(['put', 'patch'], 'projects/{id}', [ProjectController::class, 'update'])->middleware('adminmiddleware');
Route::post('/projects/{id}', [ProjectController::class, 'update']);

Route::delete('projects/{id}', [ProjectController::class, 'delete'])->middleware("adminmiddleware");

Route::post('/users/delete', [AuthController::class, 'deleteUserByName']);
Route::get('/donation-statistics', [PaymentController::class, 'getDonationStatistics']);
Route::get('/total-donations', [PaymentController::class, 'getTotalDonationsAndDate']);


Route::get('/giftcards', [GiftCardController::class, 'index']);
Route::post('/giftcards', [GiftCardController::class, 'store']);
Route::get('/giftcards/{id}', [GiftCardController::class, 'show']);
Route::put('/giftcards/{id}', [GiftCardController::class, 'update']);
Route::delete('/giftcards/{id}', [GiftCardController::class, 'destroy']);


Route::get('/metal-prices', [MetalPriceController::class, 'getPrices'])->name('metal-prices.get');
Route::post('/metal-prices/update', [MetalPriceController::class, 'updatePrices'])->middleware('adminmiddleware')->name('metal-prices.update');

Route::apiResource('messages', MessageController::class);
Route::apiResource('links', LinkController::class);
Route::apiResource('about-us', AboutUsController::class);


Route::get('gifts', [GiftController::class, 'index']);
Route::get('gifts/{id}', [GiftController::class, 'show']);
Route::post('gifts', [GiftController::class, 'store']);
Route::post('/gifts/{id}', [GiftController::class, 'update']);
Route::put('gifts/{id}', [GiftController::class, 'update']);
Route::delete('gifts/{id}', [GiftController::class, 'destroy']);
Route::apiResource('associations', AssociationController::class);
Route::post('associations/{id}', [AssociationController::class, 'update']);


Route::post('/projects/{id}/toggle-visibility', [ProjectController::class, 'toggleVisibility']);


Route::resource('integrations', IntegrationController::class);


Route::apiResource('contactInfos', ContactInfoController::class);



Route::get('/settings', [SettingsController::class, 'index']);
Route::post('/settings', [SettingsController::class, 'store']);
Route::get('/settings/{id}', [SettingsController::class, 'show']);
Route::put('/settings/{id}', [SettingsController::class, 'update']);
Route::delete('/settings/{id}', [SettingsController::class, 'destroy']);



Route::apiResource('bank-accounts', BankAccountController::class);


Route::apiResource('repairs', RepairController::class);




Route::get('categories', [CategoryController::class, 'index']);


Route::post('categories', [CategoryController::class, 'store']);


Route::post('categories/{id}', [CategoryController::class, 'update']);
Route::patch('categories/{id}', [CategoryController::class, 'update']);


Route::delete('categories/{id}', [CategoryController::class, 'destroy']);

Route::get('projects/{id}/donors', [PaymentController::class, 'getDonorsByProject']);


// API routes for SEO settings
Route::prefix('seo-settings')->group(function () {
    Route::get('/', [SeoSettingController::class, 'index']); // Get all SEO settings
    Route::get('/{id}', [SeoSettingController::class, 'show']); // Get specific SEO setting
    Route::post('/', [SeoSettingController::class, 'store']); // Create new SEO setting
    Route::put('/', [SeoSettingController::class, 'update']); // Update existing SEO setting
    Route::delete('/', [SeoSettingController::class, 'destroy']); // Delete SEO setting
});



Route::get('/users/not-donated', [PaymentController::class, 'getUsersNotDonated']);


Route::get('/coordinators', [CoordinatorController::class, 'index']);
Route::post('/coordinators', [CoordinatorController::class, 'store']);
Route::get('/coordinators/{id}', [CoordinatorController::class, 'show']);
Route::put('/coordinators/{id}', [CoordinatorController::class, 'update']);
Route::delete('/coordinators/{id}', [CoordinatorController::class, 'destroy']);


Route::post('/tracking-links', [TrackingLinkController::class, 'create']);

 Route::post('create-tracking-link', [TrackingLinkController::class, 'create']);
Route::get('tracking/{id}', [TrackingLinkController::class, 'track']);
Route::get('tracking-link/{id}', [TrackingLinkController::class, 'show']);
Route::get('tracking-links', [TrackingLinkController::class, 'index']);
Route::post('archive-tracking-link/{id}', [TrackingLinkController::class, 'archive']);
Route::post('tracking-links/{id}/unarchive', [TrackingLinkController::class, 'unarchive']);

Route::post('/tracking/{id}', [TrackingLinkController::class, 'tracking']);


Route::get('campaigns/archive', [CampaignController::class, 'archive']);
Route::apiResource('campaigns', CampaignController::class);
Route::get('/listCampaigns', [CampaignController::class, 'listCampaigns']);


Route::middleware('auth:api')->group(function () {
    Route::get('/campaigns/user', [CampaignController::class, 'userCampaigns']);
});




Route::get('/colors', [ColorController::class, 'index']);
Route::post('/colors', [ColorController::class, 'update']);



Route::post('/hadiyas', [HadiyaController::class, 'store']);
Route::get('/hadiyas', [HadiyaController::class, 'index']);



Route::apiResource('waqf-certificates', WaqfCertificateController::class);

Route::post('/pages', [PageController::class, 'store']);
Route::get('/pages/{id}', [PageController::class, 'show']);
Route::post('/pages/{id}', [PageController::class, 'update']);
Route::delete('/pages/{id}', [PageController::class, 'destroy']);
Route::get('/pages', [PageController::class, 'index']);

Route::get('/abandoned-carts', [AbandonedCartController::class, 'index']); // لاسترجاع جميع السلال
Route::delete('/abandoned-carts/{id}', [AbandonedCartController::class, 'destroy']); // لحذف سلة معينة
Route::post('/abandoned-carts', [AbandonedCartController::class, 'store']);



use App\Http\Controllers\GroupMessagesController;

// إضافة Route لإرسال الرسائل الجماعية
Route::post('/group-message', [GroupMessagesController::class, 'send']);

Route::get('/group-message', [GroupMessagesController::class, 'index']);

Route::post('/payment/callback', [PaymentController::class, 'handlePaymentCallback']);



Route::prefix('targets')->group(function () {
    Route::get('/', [TargetController::class, 'index']); // للحصول على جميع الأهداف
    Route::post('/', [TargetController::class, 'store']); // لإنشاء هدف جديد
    Route::get('/{id}', [TargetController::class, 'show']); // للحصول على هدف معين
    Route::put('/{id}', [TargetController::class, 'update']); // لتحديث هدف معين
    Route::delete('/{id}', [TargetController::class, 'destroy']); // لحذف هدف معين
});

Route::put('/targets/{id}', [TargetController::class, 'update']);


use App\Http\Controllers\StatsController;

Route::get('/stats', [StatsController::class, 'getStats']);
Route::post('/stats', [StatsController::class, 'createStats']);
Route::put('/stats/{id}', [StatsController::class, 'updateStats']);
Route::delete('/stats/{id}', [StatsController::class, 'deleteStats']);


Route::get('/fetch-prices', [MetalPriceController::class, 'fetchAndUpdatePrices']);





// routes/api.php

use App\Http\Controllers\FAQController;

Route::prefix('faq')->group(function () {
    Route::get('/', [FAQController::class, 'index']); // عرض جميع الأسئلة والأجوبة
    Route::post('/', [FAQController::class, 'store']); // إنشاء سؤال جديد
    Route::get('{id}', [FAQController::class, 'show']); // عرض سؤال معين
    Route::put('{id}', [FAQController::class, 'update']); // تحديث سؤال معين
    Route::delete('{id}', [FAQController::class, 'destroy']); // حذف سؤال معين
});


// routes/api.php

use App\Http\Controllers\ProjectRequestController;

Route::prefix('project-requests')->group(function () {
    Route::get('/', [ProjectRequestController::class, 'index']); // عرض جميع طلبات المشاريع
    Route::post('/', [ProjectRequestController::class, 'store']); // إنشاء طلب مشروع جديد
    Route::get('{id}', [ProjectRequestController::class, 'show']); // عرض طلب مشروع معين
    Route::put('{id}', [ProjectRequestController::class, 'update']); // تحديث طلب مشروع معين
    Route::delete('{id}', [ProjectRequestController::class, 'destroy']); // حذف طلب مشروع معين
});


// routes/api.php

use App\Http\Controllers\ComplaintController;

Route::prefix('complaints')->group(function () {
    Route::get('/', [ComplaintController::class, 'index']); // عرض جميع الشكاوى
    Route::post('/', [ComplaintController::class, 'store']); // إنشاء شكوى جديدة
    Route::get('{id}', [ComplaintController::class, 'show']); // عرض شكوى معينة
    Route::put('{id}', [ComplaintController::class, 'update']); // تحديث شكوى معينة
    Route::delete('{id}', [ComplaintController::class, 'destroy']); // حذف شكوى معينة
});


// routes/api.php

use App\Http\Controllers\SupportController;

Route::prefix('support')->group(function () {
    Route::get('/', [SupportController::class, 'index']); // عرض جميع طلبات الدعم
    Route::post('/', [SupportController::class, 'store']); // إنشاء طلب دعم جديد
    Route::get('{id}', [SupportController::class, 'show']); // عرض طلب دعم معين
    Route::put('{id}', [SupportController::class, 'update']); // تحديث طلب دعم معين
    Route::delete('{id}', [SupportController::class, 'destroy']); // حذف طلب دعم معين
});



Route::apiResource('partnerss', PartnerssController::class);




Route::apiResource('messages-control', MessageControlController::class);
Route::apiResource('texts', TextController::class);
Route::apiResource('website-pages', WebsitePageController::class);
Route::apiResource('edit-main-page', EditMainPageController::class);
Route::apiResource('qr-codes', QrCodeController::class);


Route::apiResource('waqfyas', WaqfyaController::class);
Route::apiResource('waqfya-data', WaqfyaDataController::class);
Route::post('/waqfya-data/update/{id}', [WaqfyaDataController::class, 'update']);




use App\Http\Controllers\ProjectSortController;

Route::get('/project_ids', [ProjectSortController::class, 'showProjectIds']);
Route::post('/project_ids', [ProjectSortController::class, 'addProjectIds']);
Route::put('/project_ids/{id}', [ProjectSortController::class, 'updateProjectId']); // يجب أن يكون مع هذا الـ Controller
Route::delete('/project_ids/{id}', [ProjectSortController::class, 'deleteProjectId']); // يجب أن يكون مع هذا الـ Controller
































